
/************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audiomanager.h
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audiomanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/

#ifndef INCLUDE_AMCONTROL_CLIENT_FC_AUD_MGR_HANDLER_H_IF
#define INCLUDE_AMCONTROL_CLIENT_FC_AUD_MGR_HANDLER_H_IF

class CAmControlSenderBase;

#include "IAmControlReceiverShadow.h"
#include "inc_fi_handler.h"

using namespace am;

class amcontrol_clienthandler_fc_audiomanager : public inc_fi_handler
{
private:

   am::IAmControlReceiverShadow *m_pControlReceiverShadowInterface;
   CAmControlSenderBase* m_pControlSenderBase;

   //Method results
    void vOnVolumeMode(amt_tclServiceData* poMessage);
    void vOnMute(amt_tclServiceData* poMessage);
    void vOnBeep(amt_tclServiceData* poMessage);
    void vOnPerformVolLimit(amt_tclServiceData* poMessage);

   //Properties
   void vOnVolumeStatus(amt_tclServiceData* poMessage);
   void vOnBassStatus(amt_tclServiceData* poMessage);
   void vOnTrebleStatus(amt_tclServiceData* poMessage);
   void vOnMidRangeStatus(amt_tclServiceData* poMessage);
   void vOnLoudnessStatus(amt_tclServiceData* poMessage);
   void vOnBalanceStatus(amt_tclServiceData* poMessage);
   void vOnFaderStatus(amt_tclServiceData* poMessage);
   void vOnDynamicCompressionStatus(amt_tclServiceData* poMessage);
   void vOnEquPresetStatus(amt_tclServiceData* poMessage);
   void vOnSpeedDepVolumeStatus(amt_tclServiceData* poMessage);
   void vOnMicConnectionStatus(amt_tclServiceData* poMessage);

   void vOnSoundOptimizationStatus(amt_tclServiceData* poMessage);
   void vOnSoundRoomEffectStatus(amt_tclServiceData* poMessage) const;
   void vOnLevelAuxInStatus(amt_tclServiceData* poMessage);

   void vOnLevelBeepStatus(amt_tclServiceData* poMessage);
   //void vOnAudioModeStatus(amt_tclServiceData* poMessage);

   void vOnLevelCenterStatus(amt_tclServiceData* poMessage) const;
   void vOnLevelSubWooferStatus(amt_tclServiceData* poMessage) const;
   void vOnSettingSurroundStatus(amt_tclServiceData* poMessage) const;
   void vOnAudioModeStatus(amt_tclServiceData* poMessage);
   void vOnVolumeModeStatus(amt_tclServiceData* poMessage);

   void vOnFaderActiveStatus(amt_tclServiceData* poMessage);

   void vOnAmpDeviceAudRoute(amt_tclServiceData* poMessage);
   void vOnAudioSource(amt_tclServiceData* poMessage);

   virtual tVoid vOnServiceAvailable();

public:
   bool m_bSeviceAvailable;

    //Wrapper function
    void vCopyDatatoFIMessageWrapper(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData);

    //Default Constructor
    amcontrol_clienthandler_fc_audiomanager(CAmControlSenderBase*,am::IAmControlReceiverShadow*);
    amcontrol_clienthandler_fc_audiomanager(tVoid);
    ~amcontrol_clienthandler_fc_audiomanager(tVoid);

   /****************************************************************************
                  Methods of this application
   ****************************************************************************/

   //methods
   tVoid vSetMute(uint8_t,uint8_t,uint8_t,uint8_t,uint8_t);
   tVoid vSetSystemSoundProperty_VolumeMode(uint8_t,uint8_t);
   tVoid vSetSystemSoundProperty_Beep(uint8_t,uint8_t);
   tVoid vPerformOnVolLimit();

   //properties
   tVoid vSetVolume(uint8_t,uint8_t,uint8_t);
   tVoid vSetAudioSource(uint8_t,uint8_t,uint8_t);
   tVoid vSetAmpDeviceAudioRoute(uint8_t,uint8_t,uint8_t);

   tVoid vSetSourceSoundProperty_AuxInLevel(uint8_t);

   tVoid vSetSinkSoundProperty_Bass(uint8_t,uint8_t,int8_t);
   tVoid vSetSinkSoundProperty_Treble(uint8_t,uint8_t,int8_t);
   tVoid vSetSinkSoundProperty_MidRange(uint8_t,uint8_t,int8_t);
   tVoid vSetSinkSoundProperty_Loudness(uint8_t,uint8_t,int8_t);
   tVoid vSetSinkSoundProperty_Balance(uint8_t,uint8_t,int8_t);
   tVoid vSetSinkSoundProperty_Fader(uint8_t,uint8_t,int8_t);
   tVoid vSetSinkSoundProperty_DynCompression(uint8_t,uint8_t);
   tVoid vSetSinkSoundProperty_PresetEquilizer(uint8_t,uint8_t);
   tVoid vSetSinkSoundProperty_SpeedDepVolChange(uint8_t,uint8_t);
   tVoid vSetSinkSoundProperty_SoundOptimization(uint8_t,uint8_t);

   /****************************************************************************
   **              Declare Message Map
   ****************************************************************************/
   /* DESCRIPTION:
   *   The message map is used to "redirect" incoming FI messages to
   *   dedicated handler functions
   ****************************************************************************/
   DECLARE_MSG_MAP(amcontrol_clienthandler_fc_audiomanager)

};

#endif //INCLUDE_AMCONTROL_CLIENT_FC_AUD_MGR_HANDLER_H_IF
